/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8235;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.MessageDialog;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.AccessDenied;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.eui.BoxDownMsg;
import ibm.nways.jdm.eui.WrongSysOidMsg;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.widgets.CookieTray;
import ibm.nways.widgets.WidgetCookie;
import java.awt.Component;
import java.awt.Point;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.Vector;

public class BoxInfo {
    private static ResourceBundle myBundle;
    private static String bundleName;
    public static final String PROPNAME = "BoxInfo.jdm8225.nways.ibm";
    public static final String serPath = "ibm.nways.jdm8235.WCDefault";
    private String boxGifName;
    private String boxFlyover;
    private String portGifName;
    private String portGifId;
    private String networkGifId;
    private static final int BRI_ST = 6;
    private static final int BRI_U = 8;
    private static final int UART = 3;
    private static final short IBM8235_032 = 11;
    private static final short IBM8235_031 = 12;
    private static final short IBM8235_021 = 14;
    private static final short IBM8235_022 = 13;
    private static final short IBM8235_001 = 7;
    private static final short IBM8235_002 = 8;
    private static final int SUCCESSFUL = 0;
    private static final int FAILED = 1;
    public static final int NoStatus = 0;
    public static final int AllisWell = 1;
    public static final int NotResponding = 2;
    public static final int WrongBox = 3;
    public static final int ServerProblems = 4;
    public final OID IBM8235_OID = new OID("1.3.6.1.4.1.166.2.4");
    public final OID IBM8235I40_OID = new OID("1.3.6.1.4.1.166.2.10");
    private GenModel deviceModel;
    private GenModel portModel;
    private GenModel portStatusModel;
    private GenModel systemModel;
    private GenModel LANAdapterModel;
    private JdmBrowser deviceBrowser;
    private int deviceStatus;
    private int retrievalStatus;
    private GraphicPanel deviceGraphic;
    private OID deviceSysOID;
    private String boxModelNumber;
    private int agentVersion;
    private boolean isApplication;
    private boolean loggingOn;
    private Integer modelNumber;
    private Vector portStatusVector;
    CookieTray jdm8235Tray;
    GraphicPanel graphicPanel;
    GraphicContainer grContainer;

    public BoxInfo(GenModel genModel, JdmBrowser jdmBrowser) {
        ModelInfo modelInfo = null;
        Serializable serializable = null;
        Serializable serializable2 = null;
        this.deviceBrowser = jdmBrowser;
        this.deviceModel = genModel;
        myBundle = ResourceBundle.getBundle(bundleName);
        try {
            modelInfo = this.deviceModel.getInfo("Initial");
            serializable = modelInfo.get("Initial.SysObjectID");
            if (serializable instanceof Timeout || serializable instanceof NotSupported || serializable instanceof AccessDenied) {
                this.deviceStatus = 2;
                this.printMsg("jdm8235: Device not responding" + serializable.toString());
                new BoxDownMsg(jdmBrowser.getFrame(), myBundle.getString("deviceName"));
                return;
            }
            this.deviceSysOID = new OID(serializable.toString());
            if (this.IBM8235I40_OID.equals(this.deviceSysOID)) {
                MessageDialog messageDialog = new MessageDialog(jdmBrowser.getFrame(), myBundle.getString("I40SupportMsg"), true);
                messageDialog.setTitle(myBundle.getString("I40SupportTitle"));
                messageDialog.show();
                return;
            }
            if (this.IBM8235_OID.equals(this.deviceSysOID)) {
                this.deviceStatus = 1;
                serializable2 = modelInfo.get("Initial.VHardware");
                this.boxModelNumber = serializable2.toString();
                return;
            }
            this.deviceStatus = 3;
            this.printMsg("jdm8235: Wrong device. SysOID = " + this.deviceSysOID);
            new WrongSysOidMsg(this.deviceBrowser.getFrame(), myBundle.getString("deviceName"));
            return;
        }
        catch (Exception exception) {
            this.deviceStatus = 4;
            this.printMsg("jdm8235: Error getting initial SysOID data");
            exception.printStackTrace();
            return;
        }
    }

    public static void setInNavContext(NavigationContext navigationContext, BoxInfo boxInfo) {
        navigationContext.put((Object)PROPNAME, (Object)boxInfo);
    }

    public static BoxInfo getFromNavContext(NavigationContext navigationContext, boolean bl) {
        return (BoxInfo)navigationContext.get((Object)PROPNAME, bl);
    }

    public JdmBrowser getDeviceBrowser() {
        return this.deviceBrowser;
    }

    public int getDeviceStatus() {
        return this.deviceStatus;
    }

    public GenModel getDeviceModel() {
        return this.deviceModel;
    }

    public GraphicPanel getDeviceGraphic() {
        if (this.deviceStatus == 1) {
            if (this.deviceGraphic != null) {
                return this.deviceGraphic;
            }
            JdmLayout jdmLayout = (JdmLayout)this.deviceBrowser.getLayout();
            jdmLayout.setScheme(0);
            this.grContainer = new GraphicContainer();
            GraphicHelp graphicHelp = new GraphicHelp((BrowserApplet)this.deviceBrowser, new Point(0, 0), new HelpRef((Object)this));
            this.grContainer.add((GraphicComponent)graphicHelp);
            this.grContainer.add((GraphicContainer)this.createDeviceGraphic());
            this.graphicPanel = new GraphicPanel((GraphicHandler)this.deviceBrowser, (Component)this.grContainer);
        }
        return this.graphicPanel;
    }

    public void dispose() {
        if (this.deviceGraphic != null) {
            this.deviceGraphic.dispose();
            this.deviceGraphic = null;
        }
    }

    private void GetPortStatusVector() {
        this.portStatusVector = new Vector();
        try {
            this.portStatusModel = (GenModel)this.deviceModel.getComponent("PortStatus");
            this.portStatusVector = this.portStatusModel.getRestOfInfo("Panel", "default", null, null);
            return;
        }
        catch (Exception exception) {
            this.printMsg(" Exception: error while getting port status model \n");
            exception.printStackTrace();
            return;
        }
    }

    private void AddNetworkConnectionWidget() {
        System.out.println(" Creating network widget .....\n");
        try {
            this.LANAdapterModel = (GenModel)this.deviceModel.getComponent("LANAdapter");
            WidgetCookie widgetCookie = new WidgetCookie(this.networkGifId, bundleName, null, serPath, this.LANAdapterModel, this.deviceBrowser, 16, "ibm.nways.jdm8235.eui.LANAdapterPanel");
            this.jdm8235Tray.AddWidget(widgetCookie);
            return;
        }
        catch (NullPointerException nullPointerException) {
            this.printMsg("Error: There was a null pointer exception");
            this.printMsg("Error: When attempted to create widget cookie" + this.networkGifId);
            return;
        }
        catch (Exception exception) {
            this.printMsg("Error: apparently there has been an exception while gettting the models");
            return;
        }
    }

    private void AddExternalModemPortWidgets() {
        int n = 1;
        while (n <= this.portStatusVector.size()) {
            String string = String.valueOf(this.portGifId) + n;
            System.out.println("i = " + n + "  \n");
            try {
                System.out.println("creating widget");
                ModelInfo modelInfo = new ModelInfo();
                System.out.println("portnumber = " + n + "\n");
                modelInfo.add("Index.SerialLineIndex", new Integer(n));
                WidgetCookie widgetCookie = new WidgetCookie(string, bundleName, modelInfo, serPath, this.portStatusModel, this.deviceBrowser, 16, "ibm.nways.jdm8235.eui.PortStatusPanel");
                this.jdm8235Tray.AddWidget(widgetCookie);
            }
            catch (NullPointerException nullPointerException) {
                this.printMsg("Error: There was a null pointer exception");
                this.printMsg("Error: When attempted to create widget cookie" + string);
            }
            catch (Exception exception) {
                this.printMsg("Error: apparently there has been an exception while gettting the models");
            }
            ++n;
        }
    }

    private void AddInternalSlotPortWidgets() {
        ModelInfo modelInfo = null;
        this.printMsg("jdm8235: Getting the Port information for models 03x");
        int n = 0;
        while (n < this.portStatusVector.size()) {
            this.portGifId = "RJ45_";
            modelInfo = (ModelInfo)this.portStatusVector.elementAt(n);
            Serializable serializable = modelInfo.get("Panel.InternalSlotType");
            if (serializable instanceof Integer) {
                if ((Integer)serializable == 3) {
                    this.portGifId = "RS232_9PIN_";
                } else if (((Integer)serializable == 6 || (Integer)serializable == 8) && (serializable = modelInfo.get("Panel.SerialLineChan")) instanceof Integer) {
                    if ((Integer)serializable == 1) {
                        this.portGifId = String.valueOf(this.portGifId) + "TOP_";
                    } else if ((Integer)serializable == 2) {
                        this.portGifId = String.valueOf(this.portGifId) + "BOT_";
                    }
                }
            }
            if ((serializable = modelInfo.get("Panel.SerialLineSlot")) instanceof Integer) {
                this.portGifId = String.valueOf(this.portGifId) + (Integer)serializable;
            }
            try {
                System.out.println("creating widget");
                ModelInfo modelInfo2 = new ModelInfo();
                modelInfo2.add("Index.SerialLineIndex", new Integer(n + 1));
                this.printMsg("jdm8235: Creating widget = " + this.portGifId);
                WidgetCookie widgetCookie = new WidgetCookie(this.portGifId, bundleName, modelInfo2, serPath, this.portStatusModel, this.deviceBrowser, 16, "ibm.nways.jdm8235.eui.PortStatusPanel");
                this.jdm8235Tray.AddWidget(widgetCookie);
            }
            catch (NullPointerException nullPointerException) {
                this.printMsg("Error: There was a null pointer exception");
                this.printMsg("Error: When attempted to create widget cookie" + this.portGifId);
            }
            catch (Exception exception) {
                this.printMsg("Error: apparently there has been an exception while gettting the models");
            }
            ++n;
        }
    }

    private void SetGraphicsVariables() {
        this.modelNumber = Integer.valueOf(this.boxModelNumber);
        switch (this.modelNumber.shortValue()) {
            case 11: {
                this.boxGifName = "ibm8235_032.gif";
                this.boxFlyover = "IBM8235_032";
                this.networkGifId = "NETWORK_PORT_032";
                return;
            }
            case 12: {
                this.boxGifName = "ibm8235_031.gif";
                this.boxFlyover = "IBM8235_031";
                this.networkGifId = "NETWORK_PORT_031";
                return;
            }
            case 8: 
            case 13: {
                if (this.portStatusVector.size() == 2) {
                    this.boxGifName = "ibm8235_052.gif";
                    this.boxFlyover = "IBM8235_052";
                    this.portGifId = "RS232_25PIN_05X_";
                    this.networkGifId = "NETWORK_PORT_052";
                    return;
                }
                if (this.portStatusVector.size() != 8) break;
                this.boxGifName = "ibm8235_022.gif";
                this.boxFlyover = "IBM8235_022";
                this.portGifId = "RS232_25PIN_";
                this.networkGifId = "NETWORK_PORT_022";
                return;
            }
            case 7: 
            case 14: {
                if (this.portStatusVector.size() == 2) {
                    this.boxGifName = "ibm8235_051.gif";
                    this.boxFlyover = "IBM8235_051";
                    this.portGifId = "RS232_25PIN_05X_";
                    this.networkGifId = "NETWORK_PORT_051";
                    return;
                }
                if (this.portStatusVector.size() != 8) break;
                this.boxGifName = "ibm8235_021.gif";
                this.boxFlyover = "IBM8235_021";
                this.portGifId = "RS232_25PIN_";
                this.networkGifId = "NETWORK_PORT_021";
                return;
            }
        }
    }

    private CookieTray createDeviceGraphic() {
        try {
            this.systemModel = (GenModel)this.deviceModel.getComponent("System");
            this.GetPortStatusVector();
            this.SetGraphicsVariables();
            System.out.println("Creating the cookie tray ");
            this.boxGifName = "/ibm/nways/jdm8235/" + this.boxGifName;
            System.out.println(" gifname " + this.boxGifName + " \n");
            this.jdm8235Tray = new CookieTray(bundleName, new Point(20, 0), this.boxGifName, this.boxFlyover, this.deviceBrowser, this.systemModel, "ibm.nways.mib2.eui.SystemPanel");
            if (this.modelNumber.shortValue() == 12 || this.modelNumber.shortValue() == 11) {
                this.AddInternalSlotPortWidgets();
            } else {
                this.AddExternalModemPortWidgets();
            }
            this.AddNetworkConnectionWidget();
        }
        catch (Exception exception) {
            this.printMsg(" Exception: error while getting port status model \n");
            exception.printStackTrace();
        }
        return this.jdm8235Tray;
    }

    private void printMsg(String string) {
        if (this.loggingOn) {
            System.out.println(string);
        }
    }

    static {
        bundleName = "ibm.nways.jdm8235.Resources";
    }
}

